//
//  PresidentDetailController.m
//  Nav
//
//  Created by Robert Górczyński on 11-07-08.
//

#import "PresidentDetailController.h"
#import "President.h"


@implementation PresidentDetailController
@synthesize president; 
@synthesize fieldLabels; 
@synthesize tempValues; 
@synthesize textFieldBeingEdited; 

- (IBAction)cancel:(id)sender { 
    [self.navigationController popViewControllerAnimated:YES]; 
} 

- (IBAction)save:(id)sender { 
	
	if (textFieldBeingEdited != nil) { 
        NSNumber *tagAsNum= [[NSNumber alloc] 
                             initWithInt:textFieldBeingEdited.tag]; 
        [tempValues setObject:textFieldBeingEdited.text forKey: tagAsNum]; 
        [tagAsNum release]; 
    } 
    for (NSNumber *key in [tempValues allKeys]) { 
        switch ([key intValue]) { 
            case kNameRowIndex: 
                president.name = [tempValues objectForKey:key]; 
                break; 
            case kFromYearRowIndex: 
                president.fromYear = [tempValues objectForKey:key]; 
                break; 
            case kToYearRowIndex: 
                president.toYear = [tempValues objectForKey:key];
                break; 
            case kPartyIndex: 
                president.party = [tempValues objectForKey:key]; 
            default: 
                break; 
        } 
    } 
    [self.navigationController popViewControllerAnimated:YES]; 
	
    NSArray *allControllers = self.navigationController.viewControllers; 
    UITableViewController *parent = [allControllers lastObject]; 
    [parent.tableView reloadData]; 
} 

- (IBAction)textFieldDone:(id)sender { 
	UITableViewCell *cell = 
	(UITableViewCell *)[[sender superview] superview]; 
    UITableView *table = (UITableView *)[cell superview]; 
    NSIndexPath *textFieldIndexPath = [table indexPathForCell:cell]; 
    NSUInteger row = [textFieldIndexPath row]; 
    row++; 
    if (row >= kNumberOfEditableRows) { 
        row = 0; 
    } 
    NSIndexPath *newPath = [NSIndexPath indexPathForRow:row inSection:0]; 
    UITableViewCell *nextCell = [self.tableView 
								 cellForRowAtIndexPath:newPath]; 
    UITextField *nextField = nil; 
    for (UIView *oneView in nextCell.contentView.subviews) { 
        if ([oneView isMemberOfClass:[UITextField class]]) 
            nextField = (UITextField *)oneView;
    } 
    [nextField becomeFirstResponder];	
} 

#pragma mark - 
- (void)viewDidLoad { 
    NSArray *array = [[NSArray alloc] initWithObjects:@"Name:", @"From:", 
                      @"To:", @"Party:", nil]; 
    self.fieldLabels = array; 
    [array release]; 
	
    UIBarButtonItem *cancelButton = [[UIBarButtonItem alloc] 
                                     initWithTitle:@"Anuluj" 
                                     style:UIBarButtonItemStylePlain 
                                     target:self 
                                     action:@selector(cancel:)]; 
    self.navigationItem.leftBarButtonItem = cancelButton; 
    [cancelButton release]; 
	
    UIBarButtonItem *saveButton = [[UIBarButtonItem alloc] 
                                   initWithTitle:@"Zapisz" 
                                   style:UIBarButtonItemStyleDone 
                                   target:self 
                                   action:@selector(save:)]; 
    self.navigationItem.rightBarButtonItem = saveButton; 
    [saveButton release]; 
	
    NSMutableDictionary *dict = [[NSMutableDictionary alloc] init]; 
    self.tempValues = dict; 
    [dict release]; 
    [super viewDidLoad]; 
} 

- (void)dealloc { 
    [president release]; 
    [fieldLabels release]; 
    [tempValues release]; 
    [textFieldBeingEdited release]; 
    [super dealloc]; 
}

#pragma mark - 
#pragma mark Metody źródła danych tabeli 
- (NSInteger)tableView:(UITableView *)tableView 
 numberOfRowsInSection:(NSInteger)section { 
    return kNumberOfEditableRows; 
} 

- (UITableViewCell *)tableView:(UITableView *)tableView 
         cellForRowAtIndexPath:(NSIndexPath *)indexPath { 
    static NSString *PresidentCellIdentifier = @"PresidentCellIdentifier"; 
	
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier: 
                             PresidentCellIdentifier]; 
    if (cell == nil) { 
		cell = [[[UITableViewCell alloc] 
				 initWithStyle:UITableViewCellStyleDefault 
				 reuseIdentifier:PresidentCellIdentifier] autorelease]; 
        UILabel *label = [[UILabel alloc] initWithFrame: 
						  CGRectMake(10, 10, 75, 25)]; 
        label.textAlignment = UITextAlignmentRight; 
        label.tag = kLabelTag; 
        label.font = [UIFont boldSystemFontOfSize:14]; 
        [cell.contentView addSubview:label]; 
        [label release]; 
		
        UITextField *textField = [[UITextField alloc] initWithFrame: 
                                  CGRectMake(90, 12, 200, 25)]; 
        textField.clearsOnBeginEditing = NO; 
        [textField setDelegate:self]; 
        textField.returnKeyType = UIReturnKeyDone; 
        [textField addTarget:self 
                      action:@selector(textFieldDone:) 
            forControlEvents:UIControlEventEditingDidEndOnExit]; 
        [cell.contentView addSubview:textField]; 
    } 
    NSUInteger row = [indexPath row]; 
	
    UILabel *label = (UILabel *)[cell viewWithTag:kLabelTag]; 
    UITextField *textField = nil; 
    for (UIView *oneView in cell.contentView.subviews) { 
        if ([oneView isMemberOfClass:[UITextField class]]) 
            textField = (UITextField *)oneView; 
    } 
    label.text = [fieldLabels objectAtIndex:row]; 
    NSNumber *rowAsNum = [[NSNumber alloc] initWithInt:row]; 
    switch (row) { 
        case kNameRowIndex: 
            if ([[tempValues allKeys] containsObject:rowAsNum]) 
                textField.text = [tempValues objectForKey:rowAsNum]; 
            else 
                textField.text = president.name; 
            break;
        case kFromYearRowIndex: 
            if ([[tempValues allKeys] containsObject:rowAsNum]) 
                textField.text = [tempValues objectForKey:rowAsNum]; 
            else 
                textField.text = president.fromYear; 
			break; 
        case kToYearRowIndex: 
			if ([[tempValues allKeys] containsObject:rowAsNum]) 
				textField.text = [tempValues objectForKey:rowAsNum]; 
			else 
				textField.text = president.toYear; 
			break; 
        case kPartyIndex: 
			if ([[tempValues allKeys] containsObject:rowAsNum]) 
				textField.text = [tempValues objectForKey:rowAsNum]; 
			else 
				textField.text = president.party; 
        default: 
            break; 
    } 
    if (textFieldBeingEdited == textField) { 
        textFieldBeingEdited = nil; 
    } 
    textField.tag = row; 
    [rowAsNum release]; 
    return cell; 
} 

#pragma mark - 
#pragma mark Metody delegata tabeli 
- (NSIndexPath *)tableView:(UITableView *)tableView 
  willSelectRowAtIndexPath:(NSIndexPath *)indexPath { 
    return nil; 
} 

#pragma mark Metody delegata pola tekstowego 
- (void)textFieldDidBeginEditing:(UITextField *)textField { 
    self.textFieldBeingEdited = textField; 
} 

- (void)textFieldDidEndEditing:(UITextField *)textField { 
    NSNumber *tagAsNum = [[NSNumber alloc] initWithInt:textField.tag]; 
    [tempValues setObject:textField.text forKey:tagAsNum]; 
    [tagAsNum release]; 
} 

@end
